
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Sep 11 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version MNG_ATP_TST.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "MNG_ATP_TST_Defines.h"
#include "MNG_TST_Utils.h"
#include "MNG_ATP_TST.h"
#include "MNG_Functions.h"
#include "CRYS_RSA_Types.h"
#include "CRYS_RSA_PRIM.h"
#include "Init_CC.h"
#include "error.h"
#include "managment_error.h"
#include "lcs_error.h"

#ifdef DX_TST_DEBUG_OTP
  #include "gen.h"
  #include "GeneralHwDefs.h"
#endif

/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
/* RKEK data structs */
extern const int TST_NumberOf_RKEKAcceptanceTests;
extern TST_MNG_RKEK_TestDataStruct TST_MNG_RKEK_TestData[];
extern TST_MNG_PUBKey_TestDataStruct TST_MNG_OEMStaticPUBKey_TestData[];

/* MTC data structs */
extern const int TST_NumberOf_MTCAcceptanceTests;
extern TST_MNG_MTC_TestDataStruct TST_MNG_MTC_TestData[];

/* OEM data structs */
extern TST_MNG_PUBKey_TestDataStruct TST_MNG_OEMPUBKey_TestData[];
extern const int TST_NumberOf_OEMAcceptanceTests;

/* SJTAG data structs */
extern TST_MNG_PUBKey_TestDataStruct TST_MNG_SJTAGPUBKey_TestData[];
extern const int TST_NumberOf_SJTAGAcceptanceTests;

/* Buffers for Random vector test */
extern DxUint8_t TST_MNG_RndBuf[MNG_TST_MAX_BUF_SIZE_IN_BYTES];
extern DxUint8_t TST_MNG_RndBuf2[MNG_TST_MAX_BUF_SIZE_IN_BYTES];
/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_RKEK      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Change the devcie state to device manufacture and reset the SEP
 * 2. Verify that the state is as expected
 * 3. Set the RKEK key using DX_MNG_SetRkekOtp API
 * 4. Set the OEM key using DX_MNG_SetOemRsaPubKeyHashOtp API
 * 5. Call _DX_AES (secret key mode) to encrypt data.
 * 6. Verify the results
 *    
 *  * Implements MNG ATP section 5.2 
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Set_And_Use_RKEK( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index = 0;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Set_And_Use_RKEK"; 
    DxUint32_t 		      TST_State = 0;
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"******** MNG_ATP_TST_Set_And_Use_RKEK Test* ********************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n \n"));
    
    /* Change the state to device manufacture */
    TST_Status = DX_MNG_ChangeLCS(TST_MNG_DEVICE_MANUFACTURE_STATE);                                    
            
    TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                           	  "DX_MNG_ChangeLCS",
                                          	  TST_MNG_RKEK_TestData[TST_index].TST_Name,
                                          	  TST_MasterTestName);
                                             
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
    
    /* Reset the SEP*/    
    TST_Status = MNG_TST_Reset_SEP();
    if (TST_Status != DX_SUCCESS)
    	return MNG_TEST_FAIL;
    
    /* Verify that the state is DEVICE MAN */
    TST_Status = DX_MNG_GetLCS(&TST_State);
    
    TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                              "DX_MNG_GetLCS",
                                              "DX_MNG_GetLCS",
                                              TST_MasterTestName);
                                                 
    if (TST_TestStatus != DX_SUCCESS)
    	return MNG_TEST_FAIL;
    
    /* Compare the state to required state */
    if (TST_State != TST_MNG_DEVICE_MANUFACTURE_STATE)
    {
    	MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! TST_Error - Device not in expected state. Current state = %d",TST_State)); 	
    	return MNG_TEST_FAIL;
    }
    
    /************ Main Loop **********/  
    for (TST_index = 0; TST_index < TST_NumberOf_RKEKAcceptanceTests; TST_index ++)
    {
      
      /* Set the RKEK with a known value */
      TST_Status = DX_MNG_SetRkekOtp(TST_MNG_RKEK_TestData[TST_index].TST_KeyLen,
                                     TST_MNG_RKEK_TestData[TST_index].TST_Key);
                                     
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_SetRkekOtp",
                                                TST_MNG_RKEK_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
      
      /* Set the OEM public key - to constant value */
      TST_Status = DX_MNG_SetOemRsaPubKeyHashOtp(TST_MNG_OEMStaticPUBKey_TestData[0].TST_E, 
                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_NLen,
                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_N);
                                                 
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_SetOemRsaPubKeyHashOtp",
                                                TST_MNG_OEMStaticPUBKey_TestData[0].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
            
	  /* Reset the SEP*/    
	   TST_Status = MNG_TST_Reset_SEP();
	   if (TST_Status != DX_SUCCESS)
	   	return MNG_TEST_FAIL;
	      
      /* Use CRYS_AES_SecretKey to verify the output is as expected */
      TST_Status = _DX_AES(TST_MNG_RKEK_TestData[TST_index].TST_IvCounter,
      					   DX_NULL,TST_MNG_RKEK_TestData[TST_index].TST_KeySize,
                           CRYS_AES_Encrypt,TST_MNG_RKEK_TestData[TST_index].TST_Mode,
                           DX_TRUE,
                           TST_MNG_RKEK_TestData[TST_index].TST_Data,TST_MNG_RKEK_TestData[TST_index].TST_DataLen,
                           TST_MNG_RKEK_TestData[TST_index].TST_Output);                                     
                         
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "CRYS_AES_SecretKey",
                                                TST_MNG_RKEK_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
     
      
      /* Compare the output with the expected one */
      TST_Status = DX_VOS_MemCmp(TST_MNG_RKEK_TestData[TST_index].TST_ExpectedOutput,
                                 TST_MNG_RKEK_TestData[TST_index].TST_Output, 
                                 TST_MNG_RKEK_TestData[TST_index].TST_DataLen);
                                 
      if (TST_Status != DX_SUCCESS)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! TST_Error - Comparison error - Master Test Name -%s \n",TST_MasterTestName)); 
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! TST_Error - Encrypted output is different than expected \n"));
        return MNG_TEST_FAIL;
      }                                     
    }
    
    return DX_SUCCESS;    

}/* End of MNG_ATP_TST_Set_And_Use_RKEK*/ 

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_OEM_PubKey      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Set the OEM pub key using DX_MNG_SetOemRsaPubKeyHashOtp API
 * 2. Build a platform key with the OEM key using DX_MNG_RSA_BuildPlatformPubKey 
 *	  API
 * 3. Use the platform key to PRIM encrypt using CRYS_RSA_PRIM_Encrypt API 
 * 4. Verify the results are as expected
 *    
 *  * Implements MNG ATP section 5.3 
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Set_And_Use_OEM_PubKey( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Set_And_Use_OEM_PubKey";
    DxUint32_t            TST_KeyType = 1; /* the key type is set to OEM*/ 
    CRYS_RSAUserPubKey_t  TST_UserPubKey;
    CRYSError_t           TST_return = CRYS_OK;
    CRYS_RSAPrimeData_t   TST_PrimData;
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"******** MNG_ATP_TST_Set_And_Use_OEM_PubKey Test* *************** \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n \n"));
    
    /************ Main Loop **********/
    for (TST_index = 0; TST_index < TST_NumberOf_OEMAcceptanceTests; TST_index++)    
    {
      /* Set the OEM public key */
      TST_Status = DX_MNG_SetOemRsaPubKeyHashOtp(TST_MNG_OEMPUBKey_TestData[TST_index].TST_E, 
                                                 TST_MNG_OEMPUBKey_TestData[TST_index].TST_NLen,
                                                 TST_MNG_OEMPUBKey_TestData[TST_index].TST_N);
                                                 
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_SetOemRsaPubKeyHashOtp",
                                                TST_MNG_OEMPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                                 
      
      /* Build public key from the OEM key, the function verifies the N and the E of the OEM key
         if the data are not verified with the saved key the function will fail */
      TST_Status = DX_MNG_RSA_BuildPlatformPubKey(TST_KeyType,
                                                  0, 
                                                  &TST_UserPubKey,
                                                  (DxUint8_t*)&TST_MNG_OEMPUBKey_TestData[TST_index].TST_E,					
                                                  1,
                                           		    TST_MNG_OEMPUBKey_TestData[TST_index].TST_NLen,
                                                  TST_MNG_OEMPUBKey_TestData[TST_index].TST_N);
                                                  
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_RSA_BuildPlatformPubKey",
                                                TST_MNG_OEMPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                                  
      
      /* Use CRYS_RSA_PRIM_Encrypt to validate the exported key */
      TST_return = CRYS_RSA_PRIM_Encrypt(&TST_UserPubKey,
                                         &TST_PrimData,
                                         TST_MNG_OEMPUBKey_TestData[TST_index].TST_Data,
                                         TST_MNG_OEMPUBKey_TestData[TST_index].TST_NLen,
                                         TST_MNG_OEMPUBKey_TestData[TST_index].TST_Output);
                                         
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_return,
                                                "CRYS_RSA_PRIM_Encrypt",
                                                TST_MNG_OEMPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                   

      
      /* compare the output of the Prim encrypt operation with pre-calculated data */
      TST_Status = DX_VOS_MemCmp(TST_MNG_OEMPUBKey_TestData[TST_index].TST_Output, TST_MNG_OEMPUBKey_TestData[TST_index].TST_ExpectedOutput, 
                                 TST_MNG_OEMPUBKey_TestData[TST_index].TST_NLen);
                    
      if (TST_Status != DX_SUCCESS)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Comparison error - Master Test Name -%s \n",TST_MasterTestName)); 
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Encrypted output is different than expected \n"));
        return MNG_TEST_FAIL;
      }              
    }
    
    
    return MNG_TEST_PASS;    
    
}/* End of MNG_ATP_TST_Set_And_Use_OEM_PubKey*/


/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_SJTAG_PubKey      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Set the SJtag pub key using DX_MNG_SetSJtagRsaPubKeyHashOtp API
 * 2. Build a platform key with the OEM key using DX_MNG_RSA_BuildPlatformPubKey 
 *	  API
 * 3. Use the platform key to PRIM encrypt using CRYS_RSA_PRIM_Encrypt API 
 * 4. Verify the results are as expected
 *    
 *  * Implements MNG ATP section 5.4
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Set_And_Use_SJTAG_PubKey( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Set_And_Use_SJTAG_PubKey";
    DxUint32_t            TST_KeyType = 0; /* the key type is set to SJTAG*/ 
    CRYS_RSAUserPubKey_t  TST_UserPubKey;
    CRYSError_t           TST_return = CRYS_OK;
    CRYS_RSAPrimeData_t   TST_PrimData;
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"****************************************************************** \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"******** MNG_ATP_TST_Set_And_Use_SJTAG_PubKey Test *************** \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"****************************************************************** \n \n"));
    
    /* Only relevant in debug mode */
  #ifdef DX_TST_DEBUG_OTP
    DX_VOS_MemSetZero((void*)DX_TST_DBG_OTP_ADDR, 128);
  #endif
  
    /************ Main Loop **********/
    for (TST_index = 0; TST_index < TST_NumberOf_SJTAGAcceptanceTests; TST_index++)    
    {
      /* Set the OEM public key */
      TST_Status = DX_MNG_SetSJtagRsaPubKeyHashOtp(TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_E, 
                                                   TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_NLen,
                                                   TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_N);
                                                 
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_SetSJtagRsaPubKeyHashOtp",
                                                TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                                 
      
      /* Build public key from the SJtag key, the function verifies the N and the E of the SJtag key
         if the data are not verified with the saved key the function will fail */
      TST_Status = DX_MNG_RSA_BuildPlatformPubKey(TST_KeyType,
                                                  0, 
                                                  &TST_UserPubKey,
                                                  (DxUint8_t*)&TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_E,					
                                                  1,
                                           		    TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_NLen,
                                                  TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_N);
                                                  
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_RSA_BuildPlatformPubKey",
                                                TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                                  
      
      /* Use CRYS_RSA_PRIM_Encrypt to validate the exported key */
      TST_return = CRYS_RSA_PRIM_Encrypt(&TST_UserPubKey,
                                         &TST_PrimData,
                                         TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Data,
                                         TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_NLen,
                                         TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Output);
                                         
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_return,
                                                "CRYS_RSA_PRIM_Encrypt",
                                                TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                   

      
      /* compare the output of the Prim encrypt operation with pre-calculated data */
      TST_Status = DX_VOS_MemCmp(TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_Output, TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_ExpectedOutput, 
                                 TST_MNG_SJTAGPUBKey_TestData[TST_index].TST_NLen);
                    
      if (TST_Status != DX_SUCCESS)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Comparison error - Master Test Name -%s \n",TST_MasterTestName)); 
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Encrypted output is different than expected \n"));
        return MNG_TEST_FAIL;
      }              
    }
    
    return MNG_TEST_PASS;    
    
}/* End of MNG_ATP_TST_Set_And_Use_OEM_PubKey*/

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Monotonic_Counter      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function test the creation and usage of the monotonic counter
 *  
 * Algorithm:       
 * 1. Create AES platform wrapper key using DX_MNG_CreatePlatformWrapperKey API
 * 2. Create a monotonic counter with the wrapper key using 
 *    DX_MNG_CreateMonotonicCounter API
 * 3. Verify the counter's value using DX_MNG_GetMonCounterVal API
 * 4. Increment the counter using DX_MNG_IncAndGetMonCounter API
 * 5. Increment the test counter
 * 6. Get the current value of the monotonic counter and verify its equal to
 *    the test counter
 * 7. Repeat steps 4-6 for X times
 *    
 *  * Implements MNG ATP section 5.5 
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Monotonic_Counter( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index, TST_j;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Monotonic_Counter"; 
    DxUint32_t            TST_Counter[TST_MNG_MAX_COUNTER_SIZE] = {0};
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"******** MNG_ATP_TST_Monotonic_Counter Test********************** \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***************************************************************** \n \n"));
    
    /************ Main Loop **********/
    for (TST_index = 0; TST_index < TST_NumberOf_MTCAcceptanceTests; TST_index ++)
    {
      /* Zero the MTC before */
      DX_VOS_MemSetZero6(TST_MNG_MTC_TestData[TST_index].TST_MTC,TST_MNG_MAX_AES_KEY_SIZE);
      
      /* Create a wrapper key */
      TST_Status = DX_MNG_CreatePlatformWrapperKey(&TST_MNG_MTC_TestData[TST_index].TST_KeyLen,        
                                                   TST_MNG_MTC_TestData[TST_index].TST_Key);
                   
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_CreatePlatformWrapperKey",
                                                TST_MNG_MTC_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL; 
      
      /* Create a monotonic counter */
      TST_Status = DX_MNG_CreateMonotonicCounter(TST_MNG_MTC_TestData[TST_index].TST_Key,
                                                 TST_MNG_MTC_TestData[TST_index].TST_KeyLen, 
                                                 &TST_MNG_MTC_TestData[TST_index].TST_WrappedMTCLen,
                                                 TST_MNG_MTC_TestData[TST_index].TST_WrappedMTC,  
                                                 TST_MNG_MTC_TestData[TST_index].TST_MTC,
                                                 &TST_MNG_MTC_TestData[TST_index].TST_MTCLen);
                                    
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_CreateMonotonicCounter",
                                                TST_MNG_MTC_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
      
      /* Get the value of the Counter */     
      TST_Status = DX_MNG_GetMonCounterVal(TST_MNG_MTC_TestData[TST_index].TST_Key,
                                           TST_MNG_MTC_TestData[TST_index].TST_KeyLen,
                                           TST_MNG_MTC_TestData[TST_index].TST_WrappedMTC,
                                           TST_MNG_MTC_TestData[TST_index].TST_WrappedMTCLen,
                                           TST_MNG_MTC_TestData[TST_index].TST_MTC,
                                           &TST_MNG_MTC_TestData[TST_index].TST_MTCLen);
                                           
      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                "DX_MNG_GetMonCounterVal",
                                                TST_MNG_MTC_TestData[TST_index].TST_Name,
                                                TST_MasterTestName);
                                                 
      if (TST_TestStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;                                           
      
      /* Compare. the value should be 0 */
      TST_Status = DX_VOS_MemCmp(TST_MNG_MTC_TestData[TST_index].TST_MTC, TST_Counter, 
                                 TST_MNG_MAX_COUNTER_SIZE);
                                 
      if (TST_Status != DX_SUCCESS)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Comparison error - Master Test Name -%s \n",TST_MasterTestName)); 
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Initial value of counter is incorrect \n"));
        return MNG_TEST_FAIL; 
      }
      
      /* Increment the counter value TST_MNG_MAX_NUM_OF_LOOPS times and check its value */
      for (TST_j = 0; TST_j < TST_MNG_MAX_NUM_OF_LOOPS; TST_j++)
      {
        /* Increment the counter value */
        TST_Status = DX_MNG_IncAndGetMonCounter(TST_MNG_MTC_TestData[TST_index].TST_Key,
                                                TST_MNG_MTC_TestData[TST_index].TST_KeyLen, 
                                                TST_MNG_MTC_TestData[TST_index].TST_WrappedMTC,
                                                TST_MNG_MTC_TestData[TST_index].TST_WrappedMTCLen,
                                                TST_MNG_MTC_TestData[TST_index].TST_MTC,
                                                &TST_MNG_MTC_TestData[TST_index].TST_MTCLen);
                                                
        TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                  "DX_MNG_IncAndGetMonCounter",
                                                  TST_MNG_MTC_TestData[TST_index].TST_Name,
                                                  TST_MasterTestName);
                                                   
        if (TST_TestStatus != DX_SUCCESS)
          return MNG_TEST_FAIL; 
        
        /* Get the current counter value */
        TST_Status = DX_MNG_GetMonCounterVal(TST_MNG_MTC_TestData[TST_index].TST_Key,
                                             TST_MNG_MTC_TestData[TST_index].TST_KeyLen, 
                                             TST_MNG_MTC_TestData[TST_index].TST_WrappedMTC,
                                             TST_MNG_MTC_TestData[TST_index].TST_WrappedMTCLen,
                                             TST_MNG_MTC_TestData[TST_index].TST_MTC,
                                             &TST_MNG_MTC_TestData[TST_index].TST_MTCLen);
                                             
        TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Status,
                                                  "DX_MNG_GetMonCounterVal",
                                                  TST_MNG_MTC_TestData[TST_index].TST_Name,
                                                  TST_MasterTestName);
                                                   
        if (TST_TestStatus != DX_SUCCESS)
          return MNG_TEST_FAIL;
        
        /* Increment the tst counter */
        MNG_TST_IncLsbUnsignedCounter(TST_Counter,
                                      1,
                                      TST_MNG_MAX_COUNTER_SIZE);  
        /* Compare the values */
        TST_Status = DX_VOS_MemCmp(TST_MNG_MTC_TestData[TST_index].TST_MTC, TST_Counter, 
                                   TST_MNG_MAX_COUNTER_SIZE);
                                   
        if (TST_Status != DX_SUCCESS)
        {
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! Comparison error - Master Test Name -%s \n",TST_MasterTestName)); 
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! The counter value is not as expected \n"));
          return MNG_TEST_FAIL; 
        }        
      }
      
    }
    
    return DX_SUCCESS;
}

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/


/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Security_Disable      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Verify if operation is allowed on current state - Set the RKEK to a known 
 *    vector by calling DX_MNG_SetRkekOtp API (the operation should fail on 
 *    MNG_SECURITY_DISABLE_LCS) 
 * 3. Change the LCS to the next state by calling DX_MNG_ChangeLCS
 * 4. Repeat the test for MNG_CHIP_MANUFACTURING_LCS, MNG_DEVICE_MANUFACTURING_LCS,
 *    MNG_SECURITY_DISABLE_LCS and MNG_RMA_LCS  
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Set_LCS_To_Security_Disable( void ) 
{

    /********* TST Variables Definitions ************/
    int                     TST_index;
    DxError_t             	TST_Result = DX_SUCCESS, TST_ExpectedResult = DX_SUCCESS, 
    						TST_TestStatus = DX_SUCCESS, TST_ExpectedResult1 = DX_SUCCESS;    
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_LCS_Acceptance";
    char                    TST_StepTestName[TST_FUNC_STRING_LEN] = "Set RKEK 256Bits size"; 
    DxUint8_t               TST_LCSState = TST_MNG_CHIP_MANUFACTURE_STATE;
    DxUint32_t              TST_ReturnedLCS; 
    DxUint32_t			    Error = 0, regVal = 0;                               
   
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"** MNG_ATP_TST_Set_LCS_To_Security_Disable Tests ********************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_index = 0; TST_index < TST_MNG_MAX_NUM_OF_STATES_DISABLE; TST_index ++)
    {
        
        /* Get the current state and verify it */ 
        /*-------------------------------------*/
        TST_Result = DX_MNG_GetLCS(&TST_ReturnedLCS);
        TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result, TST_ExpectedResult, "DX_MNG_GetLCS",
        												   TST_StepTestName, TST_MasterTestName);        
        if (TST_TestStatus != MNG_TEST_PASS) 
            return MNG_TEST_FAIL;
    
        
        if (TST_index != TST_MNG_LCS_SECURITY_DISABLE_IDX)
        {
        	if (TST_ReturnedLCS != TST_LCSState)
        	{
	            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - Current LCS is different than expected \n"));    
	            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Current LCS is %d, expected LCS is - %d \n",TST_ReturnedLCS,  TST_LCSState));            
	            return MNG_TEST_FAIL;            
       	 	}	
        }
        
        
        /* Verify operations on current state */ 
        /*------------------------------------*/
        /* Set the RKEK to a known vector, the operation should only succeed in states 
           TST_MNG_CHIP_MANUFACTURE_STATE */     
	    if (TST_LCSState != TST_MNG_DEVICE_MANUFACTURE_STATE)
	    {
		    TST_Result = DX_MNG_SetRkekOtp(TST_MNG_RKEK_TestData[0].TST_KeyLen,
		                                   TST_MNG_RKEK_TestData[0].TST_Key);
		                                     
		    TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
		    												   TST_ExpectedResult1,
				                                               "DX_MNG_SetRkekOtp",
				                                               TST_MNG_RKEK_TestData[0].TST_Name,
				                                               TST_MasterTestName);
		                                                 
		    if (TST_TestStatus != DX_SUCCESS)
		    	return MNG_TEST_FAIL;
	    }
	        
        
        /* Change the LCS to the next state */ 
        /*----------------------------------*/
                                            
        /* Set the state to the next state */
        switch(TST_index)
        {
            case TST_MNG_LCS_CHIP_MANUFACTURE_IDX:
                TST_LCSState = TST_MNG_DEVICE_MANUFACTURE_STATE;
                TST_ExpectedResult = DX_SUCCESS;
                TST_ExpectedResult1 = DX_SUCCESS;
                break;
            case TST_MNG_LCS_DEVICE_MANUFACTURE_IDX:
                TST_LCSState = TST_MNG_SECURITY_DISABLED_STATE;
                TST_ExpectedResult = DX_MNG_LCS_SECURITY_DISABLE_ERR;
                TST_ExpectedResult1 = DX_MNG_SEP_IS_DISABLE_ERR;
                break;
            case TST_MNG_LCS_SECURITY_DISABLE_IDX:                        
                /* We are actually in TST_MNG_SECURITY_DISABLED_STATE state*/
                TST_LCSState = TST_MNG_CHIP_MANUFACTURE_STATE;
                TST_ExpectedResult = MNG_TEST_FAIL;
                break;   
            default:
                return MNG_TEST_FAIL;                
        }                    
        
        if (TST_LCSState != TST_MNG_CHIP_MANUFACTURE_STATE)
        {
            TST_Result = DX_MNG_ChangeLCS(TST_LCSState);                                    
            
            TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
	                                               	  "DX_MNG_ChangeLCS",
	                                              	  TST_MNG_RKEK_TestData[0].TST_Name,
	                                              	  TST_MasterTestName);
	                                                 
	    	if (TST_TestStatus != DX_SUCCESS)
	    		return MNG_TEST_FAIL;
            /* SW reset */
            /* Reset the SEP and initialize it, only relevant in debug mode */
		    TST_Result = MNG_TST_Reset_SEP();
		    if (TST_Result != DX_SUCCESS)
		    {
		    	if (TST_LCSState == TST_MNG_SECURITY_DISABLED_STATE)
		    	{
		    		 do
					  {
					    DX_GEN_ReadRegister(GEN_HW_HOST_SEP_HOST_GPR3_REG_ADDR , regVal);
					  }while(!regVal);
					  
					  /* check the value */
					  if(regVal == 0x1)
					  {
					    /* fatal error - read error status from GPRO */
					    DX_GEN_ReadRegister(GEN_HW_HOST_SEP_HOST_GPR0_REG_ADDR , Error); 
					    if (Error != 0x80)
					    	return MNG_TEST_FAIL; 
					  }					  
		    	}
		    	else
		    		return MNG_TEST_FAIL;	
		    }
		    	
        }
                          
     }
     MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"TST_message - test passed successfully \n"));           
     return MNG_TEST_PASS;                   
                  
}/* End of MNG_ATP_TST_Set_LCS_To_Security_Disable*/ 


/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Secure_State      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Verify if operation is allowed on current state - Set the RKEK to a known 
 *    vector by calling DX_MNG_SetRkekOtp API (the operation should fail on 
 *    MNG_SECURE_LCS) 
 * 3. Change the LCS to the next state by calling DX_MNG_ChangeLCS
 * 4. Repeat the test for MNG_CHIP_MANUFACTURING_LCS, MNG_DEVICE_MANUFACTURING_LCS,
 *    MNG_SECURE_LCS and MNG_RMA_LCS  
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Set_LCS_To_Secure_State( void ) 
{

    /********* TST Variables Definitions ************/
    int                     TST_index;
    DxError_t             	TST_Result = DX_SUCCESS, TST_ExpectedResult = DX_SUCCESS, 
    						TST_TestStatus = DX_SUCCESS;    
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_LCS_Acceptance";
    char                    TST_StepTestName[TST_FUNC_STRING_LEN] = "Set RKEK 256Bits size"; 
    DxUint8_t               TST_LCSState = TST_MNG_CHIP_MANUFACTURE_STATE;
    DxUint32_t              TST_ReturnedLCS;                                
   
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"** MNG_ATP_TST_LCS_Acceptance Tests ********************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_index = 0; TST_index < TST_MNG_MAX_NUM_OF_STATES; TST_index ++)
    {
        
        /* Get the current state and verify it */ 
        /*-------------------------------------*/
        TST_Result = DX_MNG_GetLCS(&TST_ReturnedLCS);
        TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result, DX_SUCCESS, "DX_MNG_GetLCS",
        												   TST_StepTestName, TST_MasterTestName);        
        if (TST_TestStatus != MNG_TEST_PASS) 
            return MNG_TEST_FAIL;
    
        
        if (TST_ReturnedLCS != TST_LCSState)
        {
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - Current LCS is different than expected \n"));    
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Current LCS is %d, expected LCS is - %d \n",TST_ReturnedLCS,  TST_LCSState));            
            return MNG_TEST_FAIL;            
        }
        
        /* Verify operations on current state */ 
        /*------------------------------------*/
        /* Set the RKEK to a known vector, the operation should only succeed in states 
           TST_MNG_CHIP_MANUFACTURE_STATE*/     
	    if (TST_LCSState != TST_MNG_DEVICE_MANUFACTURE_STATE)
	    {
	    	TST_Result = DX_MNG_SetRkekOtp(TST_MNG_RKEK_TestData[0].TST_KeyLen,
	                                   TST_MNG_RKEK_TestData[0].TST_Key);
	                                     
		    TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
		    												   TST_ExpectedResult,
				                                               "DX_MNG_SetRkekOtp",
				                                               TST_MNG_RKEK_TestData[0].TST_Name,
				                                               TST_MasterTestName);
		                                                 
		    if (TST_TestStatus != DX_SUCCESS)
		    	return MNG_TEST_FAIL;
	    }
	    
	    
        
        if (TST_LCSState == TST_MNG_DEVICE_MANUFACTURE_STATE)
        {
        	/* Set the OEM public key - to constant value */
		      TST_Result = DX_MNG_SetOemRsaPubKeyHashOtp(TST_MNG_OEMStaticPUBKey_TestData[0].TST_E, 
		                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_NLen,
		                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_N);
		                                                 
		      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
		                                                "DX_MNG_SetOemRsaPubKeyHashOtp",
		                                                TST_MNG_OEMStaticPUBKey_TestData[0].TST_Name,
		                                                TST_MasterTestName);
		                                                 
		      if (TST_TestStatus != DX_SUCCESS)
		        return MNG_TEST_FAIL;
        }
        
        /* Change the LCS to the next state */ 
        /*----------------------------------*/
                                            
        /* Set the state to the next state */
        switch(TST_index)
        {
            case TST_MNG_LCS_CHIP_MANUFACTURE_IDX:
                TST_LCSState = TST_MNG_DEVICE_MANUFACTURE_STATE;
                TST_ExpectedResult = DX_SUCCESS;
                break;
            case TST_MNG_LCS_DEVICE_MANUFACTURE_IDX:
                TST_LCSState = TST_MNG_SECURE_STATE;
                TST_ExpectedResult = DX_SEP_MNG_ERROR_WRONG_LIFE_CYCLE_STATE;
                break;                
            case TST_MNG_LCS_SECURITY_DISABLE_IDX:
            /* In this case secure state */
                TST_LCSState = TST_MNG_RMA_STATE;
                TST_ExpectedResult = DX_SUCCESS;
                break;
            case TST_MNG_LCS_SECURITY_OR_RMA_IDX:                
                /* We are actually in DX_TST_MNG_LCS_RMA state*/
                TST_LCSState = TST_MNG_CHIP_MANUFACTURE_STATE;
                break;   
            default:
                return MNG_TEST_FAIL;                
        }                    
        
        if (TST_LCSState != TST_MNG_CHIP_MANUFACTURE_STATE)
        {
            
            TST_Result = DX_MNG_ChangeLCS(TST_LCSState);                                    
            
            if (TST_LCSState == TST_MNG_RMA_STATE)
            {
            	TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
																   DX_SEP_LCS_ERROR_DCU_NOT_ENABLE,
                                            					   "DX_MNG_ChangeLCS",
	                                              	  			   TST_MNG_RKEK_TestData[0].TST_Name,
	                                              	  			   TST_MasterTestName);
				if (TST_TestStatus != DX_SUCCESS)
	    			return MNG_TEST_FAIL;
				break;	                                              	  			   
            }
            else
            {                     	
	            TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
		                                               	  "DX_MNG_ChangeLCS",
		                                              	  TST_MNG_RKEK_TestData[0].TST_Name,
		                                              	  TST_MasterTestName);
            }
		                                                 
	    	if (TST_TestStatus != DX_SUCCESS)
	    		return MNG_TEST_FAIL;
            /* SW reset */
            /* Reset the SEP and initialize it, only relevant in debug mode */
		    TST_Result = MNG_TST_Reset_SEP();
		    if (TST_Result != DX_SUCCESS)
		    	return MNG_TEST_FAIL;
        }
                          
     }
     MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"TST_message - test passed successfully \n"));           
     return MNG_TEST_PASS;                   
                  
}/* End of MNG_ATP_TST_Set_LCS_To_Security_Disable*/ 


/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/


/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Random_Vector_Test      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Reset the seed used for random generation
 * 2. Generate a Random vector and save it using DX_MNG_GenerateVector API
 * 3. Generate a second Random vector and save it 
 * 4. Compare the random numbers and verify that are not equal
 * 5. Repeat steps 2-4 for X times 
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Random_Vector_Test( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t              TST_index, TST_Seed = DX_TST_MNG_SEED;
    DxError_t             	TST_Result = DX_SUCCESS, TST_TstStatus = DX_SUCCESS;    
    DxChar_t                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Random_Vector_Test";
   	DxUint32_t				TST_Size = TST_MNG_RND_SIZE;
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"** MNG_ATP_TST_Random_Vector_Test Tests ********************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
	/* Reset the seed used for random generation */ 
    /*-------------------------------------------*/
    TST_Result = DX_CC_MNG_resetSeed(TST_Seed);
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
			                                 "DX_CC_MNG_resetSeed",
			                                 "Reset seed",
			                                 TST_MasterTestName);
    if (TST_TstStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
        
    for (TST_index = 0; TST_index < TST_MNG_MAX_NUM_OF_LOOPS_FOR_RND_GEN; TST_index ++)
    {
        
		MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Loop Num %d generating 2 random keys and comparing\n",TST_index+1));      
		
		/* Generate a Random vector and save it */ 
        /*--------------------------------------*/
        TST_Result = DX_MNG_GenerateDRNGVector(TST_Size, TST_MNG_RndBuf);        
        
        TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
			                                     "DX_MNG_GenerateVector",
			                                     "Generate first RND NUM",
			                                     TST_MasterTestName);
        if (TST_TstStatus != MNG_TEST_PASS) 
            return MNG_TEST_FAIL;
    
        /* Generate a second Random vector and save it */ 
        /*---------------------------------------------*/
        TST_Result = DX_MNG_GenerateDRNGVector(TST_Size, TST_MNG_RndBuf2);        
        
        TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
			                                     "DX_MNG_GenerateVector",
			                                     "Generate first RND NUM",
			                                     TST_MasterTestName);
        if (TST_TstStatus != MNG_TEST_PASS) 
            return MNG_TEST_FAIL;
       
        /* Compare the random numbers and verify that are not equal */ 
        /*----------------------------------------------------------*/
        
        TST_Result = DX_VOS_MemCmp(TST_MNG_RndBuf, TST_MNG_RndBuf2, TST_Size);
        if (TST_Result == DX_SUCCESS)
        {
        	MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!TST_Error - Numbers are equal and shouldn't be !!\n"));
        	return MNG_TEST_FAIL;      	
        }
        
        TST_Size = TST_Size + TST_MNG_SIZE_TO_INCREASE;
    }
    
    return MNG_TEST_PASS;    
        
}/* End of MNG_ATP_TST_Random_Vector_Test*/ 

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_WarmBootIndication_Test      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Do Snapshot after the boot (if necessary)
 * 2. Reset SEP (warm boot)
 * 3. Call CRYS_AES to verify that the CRYS is operational 
 * 4. Clear the warm boot indication by calling DX_MNG_ClearWarmBootIndication 
 *    API
 * 5. Do Snapshot
 * 6. Reset SEP (warm boot) 
 * 7. Set the RKEK to a known vector - should fail
 * 8. Call CRYS_AES to verify that the CRYS is not operational
 * 9. Do Snapshot
 * 10. Reset the SEP (cold boot)
 * 11. Call CRYS_AES to verify that the CRYS is operational again
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_WarmBootIndication_Test( void ) 
{
    /********* TST Variables Definitions ************/    
    DxError_t             	TST_Result = DX_SUCCESS, TST_TstStatus = DX_SUCCESS;    
    DxChar_t                TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_WarmBootIndication_Test";   	
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"** MNG_ATP_WarmBootIndication_Test Tests ********************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    /* Do Snapshot */
    /*-------------*/    
    MNG_TST_Snapshot_SEP();
    
    /* Reset SEP (warm BOOT) */
    /*-----------------------*/  
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"SEP Warm Boot\n"));  
    TST_Result = MNG_TST_Reset_SEP_WarmBoot();
    if (TST_Result != DX_SUCCESS)
    	return MNG_TEST_FAIL;
    
    
    /* Call CRYS_AES to verify that the CRYS is operational */  
    /*----------------------------------------------------*/          
    TST_Result = _DX_AES(TST_MNG_RKEK_TestData[0].TST_IvCounter,
      					 TST_MNG_RKEK_TestData[0].TST_Key,CRYS_AES_Key256BitSize,
                         CRYS_AES_Encrypt,TST_MNG_RKEK_TestData[0].TST_Mode,
                         DX_FALSE,
                         TST_MNG_RKEK_TestData[0].TST_Data,TST_MNG_RKEK_TestData[0].TST_DataLen,
                         TST_MNG_RKEK_TestData[0].TST_Output);                                     
                         
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,
                                             "CRYS_AES",
                                             TST_MNG_RKEK_TestData[0].TST_Name,
                                             TST_MasterTestName);
                                             
    if (TST_TstStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
      
    
	/* Clear the warm boot indication */ 
    /*--------------------------------*/
    TST_Result = DX_MNG_ClearWarmBootIndication();
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
			                                 "DX_MNG_ClearWarmBootIndication",
			                                 "Clear warm boot indication",
			                                 TST_MasterTestName);
    if (TST_TstStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
    
    /* Do Snapshot */
    /*-------------*/
    MNG_TST_Snapshot_SEP();
    
    /* Reset SEP (warm BOOT) */
    /*-----------------------*/
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"SEP Warm Boot\n"));  
    TST_Result = MNG_TST_Reset_SEP_WarmBoot();
    if (TST_Result != DX_SUCCESS)
    	return MNG_TEST_FAIL;
            
     /* Set the RKEK to a known vector - should fail */  
    /*----------------------------------------------*/  
    TST_Result = DX_MNG_SetRkekOtp(TST_MNG_RKEK_TestData[0].TST_KeyLen,
	                               TST_MNG_RKEK_TestData[0].TST_Key);
	                                     
	TST_TstStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result, 
													  DX_MNG_SEP_IS_DISABLE_ERR,   										
		                                              "DX_MNG_SetRkekOtp",
		                                              TST_MNG_RKEK_TestData[0].TST_Name,
		                                              TST_MasterTestName);                                                 
    if (TST_TstStatus != DX_SUCCESS)
    	return MNG_TEST_FAIL;
    
    /* Call CRYS_AES to verify that the CRYS is not operational */  
    /*----------------------------------------------------------*/          
    TST_Result = _DX_AES(TST_MNG_RKEK_TestData[0].TST_IvCounter,
      					 TST_MNG_RKEK_TestData[0].TST_Key,CRYS_AES_Key256BitSize,
                         CRYS_AES_Encrypt,TST_MNG_RKEK_TestData[0].TST_Mode,
                         DX_FALSE,
                         TST_MNG_RKEK_TestData[0].TST_Data,TST_MNG_RKEK_TestData[0].TST_DataLen,
                         TST_MNG_RKEK_TestData[0].TST_Output);                                     
                         
    TST_TstStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
    												  DX_MNG_SEP_IS_DISABLE_ERR,
                                              		  "CRYS_AES",
		                                              TST_MNG_RKEK_TestData[0].TST_Name,
		                                              TST_MasterTestName);
                                             
    if (TST_TstStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;    
        
    /* Do Snapshot */
    /*-------------*/
    MNG_TST_Snapshot_SEP();
    
    /* Reset the SEP */
    /*---------------*/
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Reset the SEP \n"));  
    TST_Result = MNG_TST_Reset_SEP_No_ClearIndication();
    if (TST_Result != DX_SUCCESS)
		return MNG_TEST_FAIL;
    
    /* Call CRYS_AES to verify that the CRYS is operational again */  
    /*------------------------------------------------------------*/          
    TST_Result = _DX_AES(TST_MNG_RKEK_TestData[0].TST_IvCounter,
      					 TST_MNG_RKEK_TestData[0].TST_Key,CRYS_AES_Key256BitSize,
                         CRYS_AES_Encrypt,TST_MNG_RKEK_TestData[0].TST_Mode,
                         DX_FALSE,
                         TST_MNG_RKEK_TestData[0].TST_Data,TST_MNG_RKEK_TestData[0].TST_DataLen,
                         TST_MNG_RKEK_TestData[0].TST_Output);                                     
                         
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,
                                             "CRYS_AES",
                                             TST_MNG_RKEK_TestData[0].TST_Name,
                                             TST_MasterTestName);
                                             
    if (TST_TstStatus != DX_SUCCESS)
        return MNG_TEST_FAIL;
    
    return MNG_TEST_PASS;

}/* end of MNG_ATP_WarmBootIndication_Test*/

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/


/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Display_Versions      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function display the ROM version, the RAM version and the MW package
 *  version. 
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Display_Versions( void ) 
{

    /********* TST Variables Definitions ************/    
    DxError_t             	TST_Result = DX_SUCCESS, TST_TstStatus = DX_SUCCESS;    
    SEP_Version_t			TST_Version;
    MwVersionInfo_t			TST_MW_Version;
     
    /* Get the ROM version and display it */
    TST_Result = DX_MNG_GetROMVersion(&TST_Version);
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
		                                     "DX_MNG_GetROMVersion",
		                                     "Get ROM version",
		                                     "Display versions");
    if (TST_TstStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
    
    MNG_ATP_Print_Version(TST_Version, DX_NULL);
    DX_VOS_MemSetZero(&TST_Version,sizeof(TST_Version));
    
    /* Get the RAM version and display it */
    TST_Result = DX_MNG_GetRAMVersion(&TST_Version);
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
		                                     "DX_MNG_GetRAMVersion",
		                                     "Get RAM version",
		                                     "Display versions");
    if (TST_TstStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
    
    MNG_ATP_Print_Version(TST_Version, DX_NULL);    
    
    /* Get the MW package version and display it*/
    
    /* Set the array to constant value (assuming not used in the version) */
    DX_VOS_MemSet(TST_MW_Version, 'Z', sizeof (MwVersionInfo_t));
    
    TST_Result = DX_MNG_GetMWPackageVersion(TST_MW_Version);
    TST_TstStatus = MNG_TST_CheckErrorReturn(TST_Result,	    										
		                                     "DX_MNG_GetMWPackageVersion",
		                                     "Get MW package version",
		                                     "Display versions");
    if (TST_TstStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
    
    MNG_ATP_Print_Version(TST_Version, TST_MW_Version);
    
    return MNG_TEST_PASS;
}/* End of MNG_ATP_TST_Display_Versions*/ 

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

